<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Unified logger for Finmo
 */
function finmo_log( $message, $level = 'info' ) {
    if ( class_exists( 'WC_Logger' ) ) {
        $logger = wc_get_logger();
        $logger->log( $level, $message, array( 'source' => 'finmo-payments' ) );
        error_log($message);
    } else {
        error_log( '[Finmo] ' . strtoupper($level) . ': ' . $message );
    }
}

/**
 * Utility to safely get meta
 */
function finmo_get_meta( $order_id, $key, $default = '' ) {
    $value = get_post_meta( $order_id, $key, true );
    return $value ? $value : $default;
}